/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core.old;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.io.efs.SyncUtils;
import com.aptana.core.io.vfs.IExtendedFileInfo;
import com.aptana.core.io.vfs.Policy;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.filewatcher.FileWatcher;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.preferences.PermissionDirection;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.core.old.ILoggable;
import com.aptana.ide.syncing.core.old.ILogger;
import com.aptana.ide.syncing.core.old.ISyncEventHandler;
import com.aptana.ide.syncing.core.old.Messages;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class Synchronizer
implements ILoggable {
    public static final QualifiedName SYNC_IN_PROGRESS = new QualifiedName(Synchronizer.class.getPackage().getName(), "SYNC_IN_PROGRESS");
    private static final int DEFAULT_TIME_TOLERANCE = 1000;
    private boolean _useCRC;
    private boolean _includeCloakedFiles = false;
    private long _timeTolerance;
    private int _clientDirectoryCreatedCount;
    private int _clientDirectoryDeletedCount;
    private int _clientFileDeletedCount;
    private int _clientFileTransferedCount;
    private int _serverDirectoryCreatedCount;
    private int _serverDirectoryDeletedCount;
    private int _serverFileDeletedCount;
    private int _serverFileTransferedCount;
    private IConnectionPoint _clientFileManager;
    private IConnectionPoint _serverFileManager;
    private IFileStore _clientFileRoot;
    private IFileStore _serverFileRoot;
    private ISyncEventHandler _eventHandler;
    private ILogger logger;
    private List<IFileStore> _newFilesDownloaded;
    private List<IFileStore> _newFilesUploaded;

    public Synchronizer() {
        this(false, 1000, false);
    }

    public Synchronizer(boolean calculateCrc, int timeTolerance) {
        this(calculateCrc, timeTolerance, false);
    }

    public Synchronizer(boolean calculateCrc, int timeTolerance, boolean includeCloakedFiles) {
        if (timeTolerance < 0) {
            timeTolerance = -timeTolerance;
        }
        this._useCRC = calculateCrc;
        this._includeCloakedFiles = includeCloakedFiles;
        this._timeTolerance = timeTolerance;
        this._newFilesDownloaded = new ArrayList<IFileStore>();
        this._newFilesUploaded = new ArrayList<IFileStore>();
    }

    protected void log(String message) {
        if (this.logger != null) {
            this.logger.logInfo(message, null);
        }
    }

    public static String getCanonicalPath(IFileStore root, IFileStore file) {
        String filePath;
        String result;
        String basePath;
        block7: {
            block6: {
                basePath = null;
                result = null;
                try {
                    basePath = EFSUtils.getAbsolutePath((IFileStore)root);
                    if (basePath != null) break block6;
                    return null;
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.Synchronizer_FileNotContained, EFSUtils.getAbsolutePath((IFileStore)file), basePath));
                }
            }
            filePath = EFSUtils.getAbsolutePath((IFileStore)file);
            if (filePath != null) break block7;
            return null;
        }
        result = filePath.substring(basePath.length());
        if (result.indexOf(92) != -1) {
            result = result.replace('\\', '/');
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public int getClientDirectoryCreatedCount() {
        return this._clientDirectoryCreatedCount;
    }

    public int getClientDirectoryDeletedCount() {
        return this._clientDirectoryDeletedCount;
    }

    public int getClientFileDeletedCount() {
        return this._clientFileDeletedCount;
    }

    public int getClientFileTransferedCount() {
        return this._clientFileTransferedCount;
    }

    public ISyncEventHandler getEventHandler() {
        return this._eventHandler;
    }

    public void setEventHandler(ISyncEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    public int getServerDirectoryCreatedCount() {
        return this._serverDirectoryCreatedCount;
    }

    public int getServerDirectoryDeletedCount() {
        return this._serverDirectoryDeletedCount;
    }

    public int getServerFileDeletedCount() {
        return this._serverFileDeletedCount;
    }

    public int getServerFileTransferedCount() {
        return this._serverFileTransferedCount;
    }

    public IFileStore[] getNewFilesDownloaded() {
        return this._newFilesDownloaded.toArray(new IFileStore[this._newFilesDownloaded.size()]);
    }

    public IFileStore[] getNewFilesUploaded() {
        return this._newFilesUploaded.toArray(new IFileStore[this._newFilesUploaded.size()]);
    }

    public void setClientFileRoot(IFileStore client) {
        this._clientFileRoot = client;
    }

    public void setServerFileRoot(IFileStore server) {
        this._serverFileRoot = server;
    }

    public VirtualFileSyncPair[] getSyncItems(IConnectionPoint clientPoint, IConnectionPoint serverPoint, IFileStore client, IFileStore server, IProgressMonitor monitor) throws CoreException {
        this.setClientFileManager(clientPoint);
        this.setServerFileManager(serverPoint);
        this.setClientFileRoot(client);
        this.setServerFileRoot(server);
        IFileStore[] clientFiles = new IFileStore[]{};
        IFileStore[] serverFiles = new IFileStore[]{};
        IFileInfo clientInfo = client.fetchInfo();
        if (!clientInfo.exists()) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.syncing.core", MessageFormat.format(Messages.Synchronizer_ERR_RootNotExist, client.toString())));
        }
        IFileInfo serverInfo = server.fetchInfo();
        if (!serverInfo.exists()) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.syncing.core", MessageFormat.format(Messages.Synchronizer_ERR_RootNotExist, server.toString())));
        }
        try {
            this.setClientEventHandler(client, server);
            if (!clientInfo.isDirectory() || !serverInfo.isDirectory()) {
                if (clientInfo.exists()) {
                    clientFiles = new IFileStore[]{client};
                }
                if (serverInfo.exists()) {
                    serverFiles = new IFileStore[]{server};
                }
            } else {
                this.log(FileUtil.NEW_LINE);
                this.log(MessageFormat.format(Messages.Synchronizer_Gathering_Source, client.toString()));
                long start = System.currentTimeMillis();
                clientFiles = EFSUtils.getFiles((IFileStore)client, (boolean)true, (boolean)this._includeCloakedFiles, (IProgressMonitor)monitor);
                this.log(MessageFormat.format(Messages.Synchronizer_Completed, System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                this.log(FileUtil.NEW_LINE);
                this.log(MessageFormat.format(Messages.Synchronizer_Gathering_Destination, server.toString()));
                serverFiles = EFSUtils.getFiles((IFileStore)server, (boolean)true, (boolean)this._includeCloakedFiles, (IProgressMonitor)monitor);
                this.log(MessageFormat.format(Messages.Synchronizer_Completed, System.currentTimeMillis() - start));
                this.log(FileUtil.NEW_LINE);
                this.log(Messages.Synchronizer_Listing_Complete);
            }
        }
        finally {
            this.removeClientEventHandler(client, server);
        }
        if (!this.syncContinue(monitor)) {
            return null;
        }
        return this.createSyncItems(clientFiles, serverFiles, monitor);
    }

    public VirtualFileSyncPair[] createSyncItems(IFileStore[] clientFiles, IFileStore[] serverFiles, IProgressMonitor monitor) throws CoreException {
        this.log(String.valueOf(FileUtil.NEW_LINE) + Messages.Synchronizer_Generating_Comparison);
        HashMap<String, VirtualFileSyncPair> fileList = new HashMap<String, VirtualFileSyncPair>();
        this.reset();
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        Policy.checkCanceled((IProgressMonitor)monitor);
        int i = 0;
        while (i < clientFiles.length) {
            if (!this.syncContinue(monitor)) {
                return null;
            }
            Policy.checkCanceled((IProgressMonitor)monitor);
            monitor.worked(1);
            IFileStore clientFile = clientFiles[i];
            if (!clientFile.fetchInfo().getAttribute(32)) {
                String relativePath = Synchronizer.getCanonicalPath(this._clientFileRoot, clientFile);
                VirtualFileSyncPair item = new VirtualFileSyncPair(clientFile, null, relativePath, 6);
                fileList.put(item.getRelativePath(), item);
            }
            ++i;
        }
        i = 0;
        while (i < serverFiles.length) {
            VirtualFileSyncPair item;
            if (!this.syncContinue(monitor)) {
                return null;
            }
            Policy.checkCanceled((IProgressMonitor)monitor);
            monitor.worked(1);
            IFileStore serverFile = serverFiles[i];
            IFileInfo serverFileInfo = serverFile.fetchInfo(1024, null);
            String relativePath = Synchronizer.getCanonicalPath(this._serverFileRoot, serverFile);
            this.logDebug(FileUtil.NEW_LINE);
            this.logDebug(MessageFormat.format(Messages.Synchronizer_Comparing_Files, relativePath));
            if (!fileList.containsKey(relativePath)) {
                if (!serverFileInfo.getAttribute(32)) {
                    item = new VirtualFileSyncPair(null, serverFile, relativePath, 7);
                    fileList.put(relativePath, item);
                    this.logDebug(Messages.Synchronizer_Item_Not_On_Destination);
                }
            } else {
                item = (VirtualFileSyncPair)fileList.get(relativePath);
                item.setDestinationFile(serverFile);
                IFileInfo clientFileInfo = item.getSourceFileInfo(monitor);
                if (clientFileInfo != null || item.getSyncState() != 7) {
                    if (clientFileInfo.isDirectory() != serverFileInfo.isDirectory()) {
                        item.setSyncState(8);
                        this.logDebug(Messages.Synchronizer_Incompatible_Types);
                    } else if (serverFileInfo.isDirectory()) {
                        fileList.remove(relativePath);
                        this.logDebug(Messages.Synchronizer_Directory);
                    } else {
                        long serverFileTime = serverFileInfo.getLastModified();
                        long clientFileTime = clientFileInfo.getLastModified();
                        long timeDiff = serverFileTime - clientFileTime;
                        this.logDebug(MessageFormat.format(Messages.Synchronizer_Times_Modified, new Object[]{new long[]{clientFileTime, serverFileTime}}));
                        if (-this._timeTolerance <= timeDiff && timeDiff <= this._timeTolerance) {
                            if (this._useCRC && !serverFileInfo.isDirectory()) {
                                item.setSyncState(this.compareCRC(item));
                            } else {
                                item.setSyncState(2);
                                this.logDebug(Messages.Synchronizer_Items_Identical);
                            }
                        } else if (timeDiff < 0L) {
                            item.setSyncState(4);
                            this.logDebug(MessageFormat.format(Messages.Synchronizer_Source_Newer, new Object[]{new long[]{Math.round(Math.abs(timeDiff / 1000L))}}));
                        } else {
                            item.setSyncState(5);
                            this.logDebug(MessageFormat.format(Messages.Synchronizer_Destination_Newer, new Object[]{new long[]{Math.round(Math.abs(timeDiff / 1000L))}}));
                        }
                    }
                }
            }
            ++i;
        }
        Set keySet = fileList.keySet();
        Object[] keys = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keys);
        VirtualFileSyncPair[] syncItems = new VirtualFileSyncPair[keys.length];
        int i2 = 0;
        while (i2 < keys.length) {
            syncItems[i2] = (VirtualFileSyncPair)fileList.get(keys[i2]);
            ++i2;
        }
        return syncItems;
    }

    private void setClientEventHandler(IFileStore client, IFileStore server) {
    }

    private void removeClientEventHandler(IFileStore client, IFileStore server) {
    }

    public long getTimeTolerance() {
        return this._timeTolerance;
    }

    public void setTimeTolerance(int timeTolerance) {
        this._timeTolerance = timeTolerance;
    }

    public void setUseCRC(boolean calculateCrc) {
        this._useCRC = calculateCrc;
    }

    public boolean getUseCRC() {
        return this._useCRC;
    }

    private int compareCRC(VirtualFileSyncPair item) throws CoreException {
        int result;
        InputStream clientStream = item.getSourceInputStream();
        InputStream serverStream = item.getDestinationInputStream();
        if (clientStream != null && serverStream != null) {
            long clientCRC = this.getCRC(clientStream);
            long serverCRC = this.getCRC(serverStream);
            try {
                clientStream.close();
                serverStream.close();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)MessageFormat.format(Messages.Synchronizer_ErrorClosingStreams, item.getRelativePath()), (Throwable)e);
            }
            result = clientCRC == serverCRC ? 2 : 3;
        } else {
            result = clientStream == serverStream ? 2 : 3;
        }
        return result;
    }

    private long getCRC(InputStream stream) {
        CRC32 crc = new CRC32();
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = stream.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.Synchronizer_ErrorRetrievingCRC, (Throwable)e);
        }
        return crc.getValue();
    }

    public boolean download(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) {
        return this.downloadAndDelete(fileList, false, monitor);
    }

    public boolean downloadAndDelete(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) {
        return this.downloadAndDelete(fileList, true, monitor);
    }

    public boolean downloadAndDelete(VirtualFileSyncPair[] fileList, boolean delete, IProgressMonitor monitor) {
        FileWatcher.avoidNotify();
        try {
            this.checkFileManagers();
            this.logBeginDownloading();
            boolean result = true;
            int totalItems = fileList.length;
            this.reset();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Synchronizer_Downloading_Files, (int)fileList.length);
            Policy.checkCanceled((IProgressMonitor)subMonitor);
            int i = 0;
            block16: while (i < fileList.length) {
                VirtualFileSyncPair item = fileList[i];
                IFileStore clientFile = item.getSourceFile();
                IFileStore serverFile = item.getDestinationFile();
                Synchronizer.setSyncItemDirection(item, false, true);
                SubMonitor childMonitor = subMonitor.newChild(1);
                childMonitor.setTaskName(this.getSyncStatus(item));
                try {
                    IFileInfo clientFileInfo = item.getSourceFileInfo();
                    IFileInfo serverFileInfo = item.getDestinationFileInfo();
                    if (!this.syncEvent(item, i, totalItems, (IProgressMonitor)childMonitor)) {
                        delete = false;
                        break;
                    }
                    Policy.checkCanceled((IProgressMonitor)childMonitor);
                    switch (item.getSyncState()) {
                        case 6: {
                            if (delete) {
                                boolean wasDirectory = clientFileInfo.isDirectory();
                                clientFile.delete(0, null);
                                if (wasDirectory) {
                                    ++this._clientDirectoryDeletedCount;
                                } else {
                                    ++this._clientFileDeletedCount;
                                }
                            }
                            this.syncDone(item, (IProgressMonitor)childMonitor);
                            break;
                        }
                        case 7: {
                            IFileStore targetClientFile = EFSUtils.createFile((IFileStore)this._serverFileRoot, (IFileStore)item.getDestinationFile(), (IFileStore)this._clientFileRoot);
                            boolean exists = targetClientFile.fetchInfo().exists();
                            if (serverFileInfo.isDirectory()) {
                                this.logCreatedDirectory(targetClientFile);
                                if (!exists) {
                                    targetClientFile.mkdir(0, null);
                                    ++this._clientDirectoryCreatedCount;
                                    this._newFilesDownloaded.add(targetClientFile);
                                    Synchronizer.updatePermissions(serverFile, targetClientFile, false, PermissionDirection.DOWNLOAD, (IProgressMonitor)childMonitor);
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            this.logDownloading(serverFile);
                            try {
                                SyncUtils.copy((IFileStore)serverFile, (IFileInfo)serverFileInfo, (IFileStore)targetClientFile, (int)0, (IProgressMonitor)childMonitor);
                                ++this._serverFileTransferedCount;
                                this._newFilesDownloaded.add(targetClientFile);
                                if (!exists) {
                                    Synchronizer.updatePermissions(serverFile, targetClientFile, true, PermissionDirection.DOWNLOAD, (IProgressMonitor)childMonitor);
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            catch (CoreException e) {
                                this.logError((Exception)((Object)e));
                                if (!this.syncError(item, (Exception)((Object)e), (IProgressMonitor)childMonitor)) {
                                    result = false;
                                    break block16;
                                }
                                break;
                            }
                        }
                        case 3: 
                        case 5: {
                            this.logDownloading(serverFile);
                            if (serverFileInfo.isDirectory()) {
                                try {
                                    EFSUtils.setModificationTime((long)serverFileInfo.getLastModified(), (IFileStore)clientFile);
                                }
                                catch (CoreException e) {
                                    this.logError((Exception)((Object)e));
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            try {
                                SyncUtils.copy((IFileStore)serverFile, (IFileInfo)serverFileInfo, (IFileStore)clientFile, (int)0, (IProgressMonitor)childMonitor);
                                ++this._serverFileTransferedCount;
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            catch (CoreException e) {
                                this.logError((Exception)((Object)e));
                                if (!this.syncError(item, (Exception)((Object)e), (IProgressMonitor)childMonitor)) {
                                    result = false;
                                    break block16;
                                }
                                break;
                            }
                        }
                        default: {
                            this.syncDone(item, (IProgressMonitor)childMonitor);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.Synchronizer_ErrorDuringSync, (Throwable)ex);
                    result = false;
                    if (!this.syncError(item, ex, (IProgressMonitor)childMonitor)) break;
                }
                ++i;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            FileWatcher.resumeNotify();
        }
    }

    private String getSyncStatus(VirtualFileSyncPair item) {
        if (item.getSyncDirection() == 1) {
            return MessageFormat.format(Messages.Synchronizer_Uploading, item.getRelativePath());
        }
        if (item.getSyncDirection() == 2) {
            return MessageFormat.format(Messages.Synchronizer_Downloading, item.getRelativePath());
        }
        return MessageFormat.format(Messages.Synchronizer_Skipping_File, item.getRelativePath());
    }

    public boolean fullSync(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) {
        return this.fullSyncAndDelete(fileList, false, false, monitor);
    }

    public boolean fullSyncAndDelete(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) {
        return this.fullSyncAndDelete(fileList, true, true, monitor);
    }

    public boolean fullSyncAndDelete(VirtualFileSyncPair[] fileList, boolean deleteLocal, boolean deleteRemote, IProgressMonitor monitor) {
        FileWatcher.avoidNotify();
        try {
            this.logBeginFullSyncing();
            boolean result = true;
            int totalItems = fileList.length;
            this.reset();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Synchronizer_Synchronizing, (int)fileList.length);
            Policy.checkCanceled((IProgressMonitor)subMonitor);
            int i = 0;
            block21: while (i < fileList.length) {
                VirtualFileSyncPair item = fileList[i];
                IFileStore clientFile = item.getSourceFile();
                IFileStore serverFile = item.getDestinationFile();
                Synchronizer.setSyncItemDirection(item, false, true);
                SubMonitor childMonitor = subMonitor.newChild(1);
                childMonitor.setTaskName(this.getSyncStatus(item));
                try {
                    IFileInfo clientFileInfo = item.getSourceFileInfo((IProgressMonitor)childMonitor);
                    IFileInfo serverFileInfo = item.getDestinationFileInfo((IProgressMonitor)childMonitor);
                    if (!this.syncEvent(item, i, totalItems, (IProgressMonitor)childMonitor)) {
                        result = false;
                        break;
                    }
                    Policy.checkCanceled((IProgressMonitor)childMonitor);
                    switch (item.getSyncState()) {
                        case 4: {
                            this.logUploading(serverFile);
                            if (clientFileInfo.isDirectory()) {
                                EFSUtils.setModificationTime((long)clientFileInfo.getLastModified(), (IFileStore)serverFile);
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            try {
                                SyncUtils.copy((IFileStore)clientFile, (IFileInfo)clientFileInfo, (IFileStore)serverFile, (int)0, (IProgressMonitor)childMonitor);
                                ++this._clientFileTransferedCount;
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            catch (CoreException e) {
                                this.logError((Exception)((Object)e));
                                if (!this.syncError(item, (Exception)((Object)e), (IProgressMonitor)childMonitor)) {
                                    result = false;
                                    break block21;
                                }
                                break;
                            }
                        }
                        case 6: {
                            if (deleteLocal) {
                                boolean wasDirectory = clientFileInfo.isDirectory();
                                clientFile.delete(0, null);
                                if (wasDirectory) {
                                    ++this._clientDirectoryDeletedCount;
                                } else {
                                    ++this._clientFileDeletedCount;
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            IFileStore targetServerFile = EFSUtils.createFile((IFileStore)this._clientFileRoot, (IFileStore)item.getSourceFile(), (IFileStore)this._serverFileRoot);
                            boolean exists = targetServerFile.fetchInfo().exists();
                            if (clientFileInfo.isDirectory()) {
                                this.logCreatedDirectory(targetServerFile);
                                if (!exists) {
                                    targetServerFile.mkdir(0, null);
                                    ++this._serverDirectoryCreatedCount;
                                    this._newFilesUploaded.add(targetServerFile);
                                    Synchronizer.updatePermissions(clientFile, targetServerFile, false, PermissionDirection.UPLOAD, (IProgressMonitor)childMonitor);
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            this.logUploading(clientFile);
                            try {
                                SyncUtils.copy((IFileStore)clientFile, (IFileInfo)clientFileInfo, (IFileStore)targetServerFile, (int)0, (IProgressMonitor)childMonitor);
                                ++this._clientFileTransferedCount;
                                this._newFilesUploaded.add(targetServerFile);
                                if (!exists) {
                                    Synchronizer.updatePermissions(clientFile, targetServerFile, true, PermissionDirection.UPLOAD, (IProgressMonitor)childMonitor);
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            catch (CoreException e) {
                                this.logError((Exception)((Object)e));
                                if (!this.syncError(item, (Exception)((Object)e), (IProgressMonitor)childMonitor)) {
                                    result = false;
                                    break block21;
                                }
                                break;
                            }
                        }
                        case 5: {
                            this.logDownloading(clientFile);
                            if (serverFileInfo.isDirectory()) {
                                EFSUtils.setModificationTime((long)serverFileInfo.getLastModified(), (IFileStore)clientFile);
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            try {
                                SyncUtils.copy((IFileStore)serverFile, (IFileInfo)serverFileInfo, (IFileStore)clientFile, (int)0, (IProgressMonitor)childMonitor);
                                ++this._serverFileTransferedCount;
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            catch (CoreException e) {
                                this.logError((Exception)((Object)e));
                                if (!this.syncError(item, (Exception)((Object)e), (IProgressMonitor)childMonitor)) {
                                    result = false;
                                    break block21;
                                }
                                break;
                            }
                        }
                        case 7: {
                            if (deleteRemote) {
                                boolean wasDirectory = serverFileInfo.isDirectory();
                                serverFile.delete(0, null);
                                if (wasDirectory) {
                                    ++this._serverDirectoryDeletedCount;
                                } else {
                                    ++this._serverFileDeletedCount;
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            IFileStore targetClientFile = EFSUtils.createFile((IFileStore)this._serverFileRoot, (IFileStore)item.getDestinationFile(), (IFileStore)this._clientFileRoot);
                            boolean exists = targetClientFile.fetchInfo().exists();
                            if (serverFileInfo.isDirectory()) {
                                this.logCreatedDirectory(targetClientFile);
                                if (!exists) {
                                    targetClientFile.mkdir(0, null);
                                    ++this._clientDirectoryCreatedCount;
                                    this._newFilesDownloaded.add(targetClientFile);
                                    Synchronizer.updatePermissions(serverFile, targetClientFile, false, PermissionDirection.DOWNLOAD, (IProgressMonitor)childMonitor);
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            this.logDownloading(targetClientFile);
                            try {
                                SyncUtils.copy((IFileStore)serverFile, (IFileInfo)serverFileInfo, (IFileStore)targetClientFile, (int)0, (IProgressMonitor)childMonitor);
                                ++this._serverFileTransferedCount;
                                this._newFilesDownloaded.add(targetClientFile);
                                if (!exists) {
                                    Synchronizer.updatePermissions(serverFile, targetClientFile, true, PermissionDirection.DOWNLOAD, (IProgressMonitor)childMonitor);
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            catch (CoreException e) {
                                this.logError((Exception)((Object)e));
                                if (!this.syncError(item, (Exception)((Object)e), (IProgressMonitor)childMonitor)) {
                                    result = false;
                                    break block21;
                                }
                                break;
                            }
                        }
                        case 3: {
                            result = false;
                            IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)MessageFormat.format(Messages.Synchronizer_FullSyncCRCMismatches, item.getRelativePath()), null);
                            if (!this.syncError(item, null, (IProgressMonitor)childMonitor)) {
                                break block21;
                            }
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.Synchronizer_ErrorDuringSync, (Throwable)ex);
                    result = false;
                    if (!this.syncError(item, ex, (IProgressMonitor)childMonitor)) break;
                }
                ++i;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            FileWatcher.resumeNotify();
        }
    }

    private void reset() {
        this._clientDirectoryCreatedCount = 0;
        this._clientDirectoryDeletedCount = 0;
        this._clientFileDeletedCount = 0;
        this._clientFileTransferedCount = 0;
        this._serverDirectoryCreatedCount = 0;
        this._serverDirectoryDeletedCount = 0;
        this._serverFileDeletedCount = 0;
        this._serverFileTransferedCount = 0;
        this._newFilesDownloaded.clear();
        this._newFilesUploaded.clear();
    }

    public boolean upload(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) {
        return this.uploadAndDelete(fileList, false, monitor);
    }

    public boolean uploadAndDelete(VirtualFileSyncPair[] fileList, IProgressMonitor monitor) {
        return this.uploadAndDelete(fileList, true, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public boolean uploadAndDelete(VirtualFileSyncPair[] fileList, boolean delete, IProgressMonitor monitor) {
        FileWatcher.avoidNotify();
        try {
            this.checkFileManagers();
            this.logBeginUploading();
            result = true;
            totalItems = fileList.length;
            this.reset();
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Synchronizer_Uploading_Files, (int)fileList.length);
            Policy.checkCanceled((IProgressMonitor)subMonitor);
            i = 0;
            block16: while (i < fileList.length) {
                item = fileList[i];
                clientFile = item.getSourceFile();
                serverFile = item.getDestinationFile();
                Synchronizer.setSyncItemDirection(item, false, true);
                childMonitor = subMonitor.newChild(1);
                childMonitor.setTaskName(this.getSyncStatus(item));
                try {
                    clientFileInfo = item.getSourceFileInfo((IProgressMonitor)childMonitor);
                    serverFileInfo = item.getDestinationFileInfo((IProgressMonitor)childMonitor);
                    if (!this.syncEvent(item, i, totalItems, (IProgressMonitor)childMonitor)) {
                        result = false;
                        break;
                    }
                    Policy.checkCanceled((IProgressMonitor)childMonitor);
                    switch (item.getSyncState()) {
                        case 6: {
                            targetServerFile = EFSUtils.createFile((IFileStore)this._clientFileRoot, (IFileStore)item.getSourceFile(), (IFileStore)this._serverFileRoot);
                            exists = targetServerFile.fetchInfo().exists();
                            if (clientFileInfo.isDirectory()) {
                                if (!exists) {
                                    targetServerFile.mkdir(0, null);
                                    ++this._serverDirectoryCreatedCount;
                                    this._newFilesUploaded.add(targetServerFile);
                                    Synchronizer.updatePermissions(clientFile, targetServerFile, false, PermissionDirection.UPLOAD, (IProgressMonitor)childMonitor);
                                }
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            this.logUploading(clientFile);
                            try {
                                SyncUtils.copy((IFileStore)clientFile, (IFileInfo)clientFileInfo, (IFileStore)targetServerFile, (int)0, (IProgressMonitor)childMonitor);
                                ++this._clientFileTransferedCount;
                                this._newFilesUploaded.add(targetServerFile);
                                if (!exists) {
                                    Synchronizer.updatePermissions(clientFile, targetServerFile, true, PermissionDirection.UPLOAD, (IProgressMonitor)childMonitor);
                                }
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            catch (CoreException e) {
                                this.logError((Exception)e);
                                if (!this.syncError(item, (Exception)e, (IProgressMonitor)childMonitor)) {
                                    result = false;
                                    break block16;
                                }
                                break;
                            }
                        }
                        case 7: {
                            if (delete) {
                                wasDirectory = serverFileInfo.isDirectory();
                                serverFile.delete(0, (IProgressMonitor)childMonitor);
                                if (wasDirectory) {
                                    ++this._serverDirectoryDeletedCount;
                                } else {
                                    ++this._serverFileDeletedCount;
                                }
                            }
                            this.syncDone(item, (IProgressMonitor)childMonitor);
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.logUploading(clientFile);
                            if (!clientFileInfo.isDirectory()) ** GOTO lbl80
                            try {
                                EFSUtils.setModificationTime((long)clientFileInfo.getLastModified(), (IFileStore)serverFile);
                            }
                            catch (CoreException e) {
                                this.logError((Exception)e);
                                if (this.syncError(item, (Exception)e, (IProgressMonitor)childMonitor)) ** GOTO lbl77
                                result = false;
                                break block16;
                            }
lbl77:
                            // 2 sources

                            this.logSuccess();
                            this.syncDone(item, (IProgressMonitor)childMonitor);
                            break;
lbl80:
                            // 1 sources

                            try {
                                SyncUtils.copy((IFileStore)clientFile, (IFileInfo)clientFileInfo, (IFileStore)serverFile, (int)0, (IProgressMonitor)childMonitor);
                                ++this._clientFileTransferedCount;
                                this.logSuccess();
                                this.syncDone(item, (IProgressMonitor)childMonitor);
                                break;
                            }
                            catch (CoreException e) {
                                this.logError((Exception)e);
                                if (!this.syncError(item, (Exception)e, (IProgressMonitor)childMonitor)) {
                                    result = false;
                                    break block16;
                                }
                                break;
                            }
                        }
                        default: {
                            this.syncDone(item, (IProgressMonitor)childMonitor);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.Synchronizer_ErrorDuringSync, (Throwable)ex);
                    result = false;
                    if (!this.syncError(item, ex, (IProgressMonitor)childMonitor)) break;
                }
                ++i;
            }
            var18_21 = result;
            return var18_21;
        }
        finally {
            FileWatcher.resumeNotify();
        }
    }

    private static void setSyncItemDirection(VirtualFileSyncPair item, boolean upload, boolean full) {
        int direction = 0;
        switch (item.getSyncState()) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                if (upload) {
                    direction = 1;
                    break;
                }
                if (full) break;
                direction = 2;
                break;
            }
            case 4: 
            case 6: {
                if (!upload && !full) break;
                direction = 1;
                break;
            }
            case 5: 
            case 7: {
                if (upload && !full) break;
                direction = 2;
            }
        }
        item.setSyncDirection(direction);
    }

    private static void updatePermissions(IFileStore sourceFileStore, IFileStore targetFileStore, boolean isFile, PermissionDirection direction, IProgressMonitor monitor) {
        if (PreferenceUtils.getUpdatePermissions((PermissionDirection)direction)) {
            IFileInfo targetFileInfo = Synchronizer.getFileInfo(targetFileStore, monitor);
            long permissions = 0L;
            if (PreferenceUtils.getSpecificPermissions((PermissionDirection)direction)) {
                permissions = isFile ? PreferenceUtils.getFilePermissions((PermissionDirection)direction) : PreferenceUtils.getFolderPermissions((PermissionDirection)direction);
            } else {
                IFileInfo sourceFileInfo = Synchronizer.getFileInfo(sourceFileStore, monitor);
                if (sourceFileInfo != null) {
                    permissions = Synchronizer.getPermissions(sourceFileInfo);
                }
            }
            if (permissions > 0L) {
                if (targetFileInfo instanceof IExtendedFileInfo) {
                    ((IExtendedFileInfo)targetFileInfo).setPermissions(permissions);
                } else {
                    targetFileInfo.setAttribute(0x400000, (permissions & 0x100L) != 0L);
                    targetFileInfo.setAttribute(0x800000, (permissions & 0x80L) != 0L);
                    targetFileInfo.setAttribute(0x1000000, (permissions & 0x40L) != 0L);
                    targetFileInfo.setAttribute(0x2000000, (permissions & 0x20L) != 0L);
                    targetFileInfo.setAttribute(0x4000000, (permissions & 0x10L) != 0L);
                    targetFileInfo.setAttribute(0x8000000, (permissions & 8L) != 0L);
                    targetFileInfo.setAttribute(0x10000000, (permissions & 4L) != 0L);
                    targetFileInfo.setAttribute(0x20000000, (permissions & 2L) != 0L);
                    targetFileInfo.setAttribute(0x40000000, (permissions & 1L) != 0L);
                }
            }
            try {
                if (targetFileInfo instanceof IExtendedFileInfo) {
                    targetFileStore.putInfo(targetFileInfo, 65536, monitor);
                } else {
                    targetFileStore.putInfo(targetFileInfo, 1024, monitor);
                }
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)SyncingPlugin.getDefault(), (String)("Failed to update permissions for " + targetFileStore), (Throwable)e);
            }
        }
    }

    private static IFileInfo getFileInfo(IFileStore fileStore, IProgressMonitor monitor) {
        IFileInfo fileInfo = (IFileInfo)fileStore.getAdapter(IFileInfo.class);
        if (fileInfo != null) {
            return fileInfo;
        }
        try {
            return fileStore.fetchInfo(0, monitor);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static long getPermissions(IFileInfo fileInfo) {
        if (fileInfo instanceof IExtendedFileInfo) {
            return ((IExtendedFileInfo)fileInfo).getPermissions();
        }
        long permissions = 0L;
        permissions |= fileInfo.getAttribute(0x400000) ? 256L : 0L;
        permissions |= fileInfo.getAttribute(0x800000) ? 128L : 0L;
        permissions |= fileInfo.getAttribute(0x1000000) ? 64L : 0L;
        permissions |= fileInfo.getAttribute(0x2000000) ? 32L : 0L;
        permissions |= fileInfo.getAttribute(0x4000000) ? 16L : 0L;
        permissions |= fileInfo.getAttribute(0x8000000) ? 8L : 0L;
        permissions |= fileInfo.getAttribute(0x10000000) ? 4L : 0L;
        permissions |= fileInfo.getAttribute(0x20000000) ? 2L : 0L;
        return permissions |= fileInfo.getAttribute(0x40000000) ? 1L : 0L;
    }

    public IConnectionPoint getClientFileManager() {
        return this._clientFileManager;
    }

    public void setClientFileManager(IConnectionPoint fileManager) {
        this._clientFileManager = fileManager;
    }

    public IConnectionPoint getServerFileManager() {
        return this._serverFileManager;
    }

    public void setServerFileManager(IConnectionPoint fileManager) {
        this._serverFileManager = fileManager;
    }

    public void resetTimeTolerance() {
        this._timeTolerance = 1000L;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    private void checkFileManagers() {
        if (this.getClientFileManager() == null) {
            throw new NullPointerException(Messages.Synchronizer_ClientFileManagerCannotBeNull);
        }
        if (this.getServerFileManager() == null) {
            throw new NullPointerException(Messages.Synchronizer_ServerFileManagerCannotBeNull);
        }
    }

    private void logBeginDownloading() {
        this.log(String.valueOf(FileUtil.NEW_LINE) + FileUtil.NEW_LINE + MessageFormat.format(Messages.Synchronizer_BeginningDownload, Synchronizer.getTimestamp()));
    }

    private void logBeginFullSyncing() {
        this.log(String.valueOf(FileUtil.NEW_LINE) + FileUtil.NEW_LINE + MessageFormat.format(Messages.Synchronizer_BeginningFullSync, Synchronizer.getTimestamp()));
    }

    private void logBeginUploading() {
        this.log(String.valueOf(FileUtil.NEW_LINE) + FileUtil.NEW_LINE + MessageFormat.format(Messages.Synchronizer_BeginningUpload, Synchronizer.getTimestamp()));
    }

    private void logCreatedDirectory(IFileStore file) {
        this.log(String.valueOf(FileUtil.NEW_LINE) + MessageFormat.format(Messages.Synchronizer_CreatedDirectory, EFSUtils.getAbsolutePath((IFileStore)file)));
    }

    private void logDownloading(IFileStore file) {
        this.log(String.valueOf(FileUtil.NEW_LINE) + MessageFormat.format(Messages.Synchronizer_Downloading, EFSUtils.getAbsolutePath((IFileStore)file)));
    }

    private void logDebug(String message) {
    }

    private void logError(Exception e) {
        IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (Throwable)e);
        if (this.logger != null) {
            if (e.getCause() != null) {
                this.log(MessageFormat.format(Messages.Synchronizer_Error_Extended, e.getLocalizedMessage(), e.getCause().getLocalizedMessage()));
            } else {
                this.log(MessageFormat.format(Messages.Synchronizer_Error, e.getLocalizedMessage()));
            }
        }
    }

    private void logSuccess() {
        this.log(Messages.Synchronizer_Success);
    }

    private void logUploading(IFileStore file) {
        this.log(String.valueOf(FileUtil.NEW_LINE) + MessageFormat.format(Messages.Synchronizer_Uploading, EFSUtils.getAbsolutePath((IFileStore)file)));
    }

    private void syncDone(VirtualFileSyncPair item, IProgressMonitor monitor) {
        if (this._eventHandler != null) {
            this._eventHandler.syncDone(item, monitor);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    private boolean syncError(VirtualFileSyncPair item, Exception e, IProgressMonitor monitor) {
        return this._eventHandler == null || this._eventHandler.syncErrorEvent(item, e, monitor);
    }

    private boolean syncEvent(VirtualFileSyncPair item, int index, int totalItems, IProgressMonitor monitor) {
        return this._eventHandler == null || this._eventHandler.syncEvent(item, index, totalItems, monitor);
    }

    private boolean syncContinue(IProgressMonitor monitor) {
        return this._eventHandler == null || this._eventHandler.syncContinue(monitor);
    }

    private static String getTimestamp() {
        Date d = new Date();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        return df.format(d);
    }

    public void disconnect() {
        try {
            this.getClientFileManager().disconnect(null);
            this.getServerFileManager().disconnect(null);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (Throwable)e);
        }
    }
}

